/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "interface.h"
#include "support.h"

/* Widget Names */
#define BOARD_NAME "CNVS_GAMEBOARD"


/* the board size */
#define BOARD_SIZE 10
/* border around the board itself */
#define BOARD_BORDER 15
/* cell size on the board */
#define CELL_SIZE 40 
/* cell padding */
#define CELL_PAD 6
/* square colors */
#define SQUARE_COLOR_1 "white"
#define SQUARE_COLOR_2 "grey"

#define THICKNESS 3


/* Prototypes */
static void init_game_board(GtkWidget *GamazonsMain);
static void draw_a_line(GnomeCanvasGroup *group, 
	int x1, int y1, int x2, int y2, char *color);
void static fill_a_square(GnomeCanvasGroup *group,
       	double x1, double y1, double x2, double y2, char *color);
static void get_square_color(int square, char *color);
void draw_board();


/* Globals */
GnomeCanvas *canvas;
int GameBoard[BOARD_SIZE][BOARD_SIZE];

/* Possible square occupants */
enum {
   NOTHING,
   BLACK,
   WHITE,
   ARROW
};



int
main (int argc, char *argv[])
{
  GtkWidget *GamazonsMain;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
                      argc, argv,
                      GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
                      NULL);

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  GamazonsMain = create_GamazonsMain ();
  init_game_board(GamazonsMain);
  gtk_widget_show (GamazonsMain);

  gtk_main ();
  return 0;
}



static void init_game_board(GtkWidget *GamazonsMain)
{
   int i,j;
   char color[256];
   GtkWidget *w = lookup_widget(GamazonsMain, BOARD_NAME);

   canvas = GNOME_CANVAS(w);

   /* set where can the canvas scroll (our usable area) */
   gnome_canvas_set_scroll_region(canvas, 0.0, 0.0,
	   BOARD_SIZE*CELL_SIZE + 2*BOARD_BORDER,
	   BOARD_SIZE*CELL_SIZE + BOARD_BORDER);

   /* set the size of the widget */
   gtk_widget_set_usize(w,
	   BOARD_SIZE*CELL_SIZE + 2*BOARD_BORDER,
	   BOARD_SIZE*CELL_SIZE + BOARD_BORDER);


   /* initialize pieces */
   for (i=0; i<BOARD_SIZE; i++)
     {
      for (j=0; j<BOARD_SIZE; j++)
	{
	 GameBoard[i][j] = NOTHING;
	}
     }

   GameBoard[3][9] = WHITE;
   GameBoard[6][9] = WHITE;
   GameBoard[0][6] = WHITE;
   GameBoard[9][6] = WHITE;

   GameBoard[3][0] = BLACK;
   GameBoard[6][0] = BLACK;
   GameBoard[0][3] = BLACK;
   GameBoard[9][3] = BLACK;

   draw_board();


}

static void
draw_a_line(GnomeCanvasGroup *group,
       	int x1, int y1, int x2, int y2, char *color)
{
   GnomeCanvasPoints *points;

   /* allocate a new points array */
   points = gnome_canvas_points_new (2);

   /* fill out the points */
   points->coords[0] = x1;
   points->coords[1] = y1;
   points->coords[2] = x2;
   points->coords[3] = y2;
   /* draw the line */
   gnome_canvas_item_new(group,
	   gnome_canvas_line_get_type(),
	   "points", points,
	   "fill_color", color,
	   "width_units", (double)THICKNESS,
	   NULL);

   /* free the points array */
   gnome_canvas_points_free(points);
}

void fill_a_square(GnomeCanvasGroup *group,
       	double x1, double y1, double x2, double y2, char *color)
{
   /* draw the line */
   gnome_canvas_item_new(group,
	   GNOME_TYPE_CANVAS_RECT,
	   "x1", x1,
	   "y1", y1,
	   "x2", x2,
	   "y2", y2,
	   "outline_color", "black",
	   "fill_color", color,
	   "width_pixels", (double)THICKNESS,
	   NULL);

}

static void get_square_color(int square, char *color)
{
   if ((square % 2) == 0)
      strcpy(color, SQUARE_COLOR_1);
   else
      strcpy(color, SQUARE_COLOR_2);
}


void draw_board()
{
   int i,j;
   GdkPixbuf *white_pb, *black_pb;
   char color[256];
   GnomeCanvasItem *image;
   GnomeCanvasGroup *root = GNOME_CANVAS_GROUP(gnome_canvas_root (GNOME_CANVAS (canvas)));


   white_pb = gdk_pixbuf_new_from_file("/home/yorgasor/Projects/Gamazons/src/white.png", NULL);
   if (white_pb == NULL)
      printf("error loading white.png\n");
   else
      printf("loaded white.png just fine\n");
   black_pb = gdk_pixbuf_new_from_file("/home/yorgasor/Projects/Gamazons/src/black.png", NULL);
   if (black_pb == NULL)
      printf("error loading black.png\n");

   /* fill alternate squares */
   for(i=0;i<BOARD_SIZE;i++) 
     {
      for(j=0;j<BOARD_SIZE;j++) 
	{
	 get_square_color(i+j, color);
	 fill_a_square(gnome_canvas_root(canvas),
		 BOARD_BORDER + i*CELL_SIZE,
		 BOARD_BORDER + j*CELL_SIZE,
		 BOARD_BORDER + i*(CELL_SIZE) + CELL_SIZE,
		 BOARD_BORDER + j*(CELL_SIZE) + CELL_SIZE,
		 color);
	 if (GameBoard[i][j] == WHITE)
	   {
	    printf("Square %dx%d contains a white queen\n",i,j);
	    image = gnome_canvas_item_new (root,
		    gnome_canvas_pixbuf_get_type (),
		    "x", i*40.0+15.0, "y", j*40.0+15.0,
		    "width", 40.0, "height", 40.0,
		    "width_set", TRUE, "height_set", TRUE,
		    "pixbuf", white_pb,
		    NULL);
	   }
	 else if (GameBoard[i][j] == BLACK)
	   {
	    printf("Square %dx%d contains a black queen\n",i,j);
	    image = gnome_canvas_item_new (root,
		    gnome_canvas_pixbuf_get_type (),
		    "x", i*40+15.0, "y", j*40+15.0,
		    "width", 40.0, "height", 40.0,
		    "width_set", TRUE, "height_set", TRUE,
		    "pixbuf", black_pb,
		    NULL);
	   }

	}
     }
   /*
   image = gnome_canvas_item_new (root,
	   gnome_canvas_pixbuf_get_type (),
	   "x", 10.0, "y", 10.0,
	   "width", 40.0, "height", 40.0,
	   "width_set", TRUE, "height_set", TRUE,
	   "pixbuf", white_pb,
	   NULL);
	   */

}
