/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpdrawablefilter_pdb.h
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#if !defined (__GIMP_H_INSIDE__) && !defined (GIMP_COMPILATION)
#error "Only <libgimp/gimp.h> can be included directly."
#endif

#ifndef __GIMP_DRAWABLE_FILTER_PDB_H__
#define __GIMP_DRAWABLE_FILTER_PDB_H__

G_BEGIN_DECLS

/* For information look into the C source or the html documentation */


gboolean                    gimp_drawable_filter_id_is_valid             (gint                      filter_id);
GimpDrawableFilter*         gimp_drawable_filter_new                     (GimpDrawable             *drawable,
                                                                          const gchar              *operation_name,
                                                                          const gchar              *name);
gchar*                      gimp_drawable_filter_get_name                (GimpDrawableFilter       *filter);
gchar*                      gimp_drawable_filter_get_operation_name      (GimpDrawableFilter       *filter);
gboolean                    gimp_drawable_filter_get_visible             (GimpDrawableFilter       *filter);
gboolean                    gimp_drawable_filter_set_visible             (GimpDrawableFilter       *filter,
                                                                          gboolean                  visible);
gdouble                     gimp_drawable_filter_get_opacity             (GimpDrawableFilter       *filter);
GimpLayerMode               gimp_drawable_filter_get_blend_mode          (GimpDrawableFilter       *filter);
G_GNUC_INTERNAL gboolean    _gimp_drawable_filter_update                 (GimpDrawableFilter       *filter,
                                                                          const gchar             **propnames,
                                                                          const GimpValueArray     *propvalues,
                                                                          gdouble                   opacity,
                                                                          GimpLayerMode             blend_mode,
                                                                          GimpLayerColorSpace       blend_space,
                                                                          GimpLayerCompositeMode    composite_mode,
                                                                          GimpLayerColorSpace       composite_space,
                                                                          const gchar             **auxinputnames,
                                                                          const GimpDrawable      **auxinputs);
G_GNUC_INTERNAL gint        _gimp_drawable_filter_get_number_arguments   (GimpDrawableFilter       *filter);
G_GNUC_INTERNAL GParamSpec* _gimp_drawable_filter_get_pspec              (GimpDrawableFilter       *filter,
                                                                          gint                      arg_num);
G_GNUC_INTERNAL gchar**     _gimp_drawable_filter_get_arguments          (GimpDrawableFilter       *filter,
                                                                          GimpValueArray          **values);
gboolean                    gimp_drawable_filter_delete                  (GimpDrawableFilter       *filter);
gchar**                     gimp_drawable_filter_operation_get_available (void);
gboolean                    gimp_drawable_filter_operation_get_details   (const gchar              *operation_name,
                                                                          gchar                  ***propnames,
                                                                          GimpValueArray          **propvalues);
GimpValueArray*             gimp_drawable_filter_operation_get_pspecs    (const gchar              *operation_name);


G_END_DECLS

#endif /* __GIMP_DRAWABLE_FILTER_PDB_H__ */
