// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/gkehub/v1alpha/multiclusteringress/multiclusteringress.proto

package multiclusteringress

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Billing identifies which billing structure the customer is using.
type Billing int32

const (
	// Unknown
	Billing_BILLING_UNSPECIFIED Billing = 0
	// User pays a fee per-endpoint.
	Billing_PAY_AS_YOU_GO Billing = 1
	// User is paying for Anthos as a whole.
	Billing_ANTHOS_LICENSE Billing = 2
)

// Enum value maps for Billing.
var (
	Billing_name = map[int32]string{
		0: "BILLING_UNSPECIFIED",
		1: "PAY_AS_YOU_GO",
		2: "ANTHOS_LICENSE",
	}
	Billing_value = map[string]int32{
		"BILLING_UNSPECIFIED": 0,
		"PAY_AS_YOU_GO":       1,
		"ANTHOS_LICENSE":      2,
	}
)

func (x Billing) Enum() *Billing {
	p := new(Billing)
	*p = x
	return p
}

func (x Billing) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Billing) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_enumTypes[0].Descriptor()
}

func (Billing) Type() protoreflect.EnumType {
	return &file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_enumTypes[0]
}

func (x Billing) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Billing.Descriptor instead.
func (Billing) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_rawDescGZIP(), []int{0}
}

// **Multi-cluster Ingress**: The configuration for the MultiClusterIngress
// feature.
type FeatureSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Fully-qualified Membership name which hosts the MultiClusterIngress CRD.
	// Example: `projects/foo-proj/locations/global/memberships/bar`
	ConfigMembership string `protobuf:"bytes,1,opt,name=config_membership,json=configMembership,proto3" json:"config_membership,omitempty"`
	// Customer's billing structure
	Billing Billing `protobuf:"varint,2,opt,name=billing,proto3,enum=google.cloud.gkehub.multiclusteringress.v1alpha.Billing" json:"billing,omitempty"`
}

func (x *FeatureSpec) Reset() {
	*x = FeatureSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FeatureSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureSpec) ProtoMessage() {}

func (x *FeatureSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureSpec.ProtoReflect.Descriptor instead.
func (*FeatureSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_rawDescGZIP(), []int{0}
}

func (x *FeatureSpec) GetConfigMembership() string {
	if x != nil {
		return x.ConfigMembership
	}
	return ""
}

func (x *FeatureSpec) GetBilling() Billing {
	if x != nil {
		return x.Billing
	}
	return Billing_BILLING_UNSPECIFIED
}

var File_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto protoreflect.FileDescriptor

var file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_rawDesc = []byte{
	0x0a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x2f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62,
	0x2e, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8e, 0x01, 0x0a, 0x0b, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x2b, 0x0a, 0x11, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x52, 0x0a, 0x07, 0x62, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x52, 0x07, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2a, 0x49, 0x0a, 0x07, 0x42,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x17, 0x0a, 0x13, 0x42, 0x49, 0x4c, 0x4c, 0x49, 0x4e,
	0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x11, 0x0a, 0x0d, 0x50, 0x41, 0x59, 0x5f, 0x41, 0x53, 0x5f, 0x59, 0x4f, 0x55, 0x5f, 0x47, 0x4f,
	0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x41, 0x4e, 0x54, 0x48, 0x4f, 0x53, 0x5f, 0x4c, 0x49, 0x43,
	0x45, 0x4e, 0x53, 0x45, 0x10, 0x02, 0x42, 0xcf, 0x02, 0x0a, 0x33, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68,
	0x75, 0x62, 0x2e, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x18,
	0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x62, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65,
	0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2f, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x3b, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0xaa, 0x02,
	0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47, 0x6b,
	0x65, 0x48, 0x75, 0x62, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61,
	0xca, 0x02, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x47, 0x6b, 0x65, 0x48, 0x75, 0x62, 0x5c, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0xea, 0x02, 0x33, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x47, 0x6b, 0x65, 0x48, 0x75, 0x62, 0x3a, 0x3a, 0x4d, 0x75, 0x6c, 0x74,
	0x69, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x3a,
	0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_rawDescOnce sync.Once
	file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_rawDescData = file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_rawDesc
)

func file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_rawDescGZIP() []byte {
	file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_rawDescData)
	})
	return file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_rawDescData
}

var file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_goTypes = []interface{}{
	(Billing)(0),        // 0: google.cloud.gkehub.multiclusteringress.v1alpha.Billing
	(*FeatureSpec)(nil), // 1: google.cloud.gkehub.multiclusteringress.v1alpha.FeatureSpec
}
var file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_depIdxs = []int32{
	0, // 0: google.cloud.gkehub.multiclusteringress.v1alpha.FeatureSpec.billing:type_name -> google.cloud.gkehub.multiclusteringress.v1alpha.Billing
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_init() }
func file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_init() {
	if File_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FeatureSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_msgTypes,
	}.Build()
	File_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto = out.File
	file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_rawDesc = nil
	file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_goTypes = nil
	file_google_cloud_gkehub_v1alpha_multiclusteringress_multiclusteringress_proto_depIdxs = nil
}
