% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distTree.R
\name{NJ}
\alias{NJ}
\alias{UNJ}
\title{Neighbor-Joining}
\usage{
NJ(x)

UNJ(x)
}
\arguments{
\item{x}{A distance matrix.}
}
\value{
an object of class \code{"phylo"}.
}
\description{
This function performs the neighbor-joining tree estimation of Saitou and
Nei (1987). UNJ is the unweighted version from Gascuel (1997).
}
\examples{

data(Laurasiatherian)
dm <- dist.ml(Laurasiatherian)
tree <- NJ(dm)
plot(tree)

}
\references{
Saitou, N. and Nei, M. (1987) The neighbor-joining method: a new
method for reconstructing phylogenetic trees. \emph{Molecular Biology and
Evolution}, \bold{4}, 406--425.

Studier, J. A and Keppler, K. J. (1988) A Note on the Neighbor-Joining
Algorithm of Saitou and Nei. \emph{Molecular Biology and Evolution},
\bold{6}, 729--731.

Gascuel, O. (1997) Concerning the NJ algorithm and its unweighted version,
UNJ. in Birkin et. al. \emph{Mathematical Hierarchies and Biology},
149--170.
}
\seealso{
\code{\link[ape]{nj}}, \code{\link[ape]{dist.dna}},
\code{\link[phangorn]{dist.hamming}}, \code{\link[phangorn]{upgma}},
\code{\link[ape]{fastme}}
}
\author{
Klaus P. Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
