// This tests the parser recovery in `recover_intersection_pat`
// and serves as a regression test for the diagnostics issue #65400.
//
// The general idea is that for `$pat_lhs @ $pat_rhs` where
// `$pat_lhs` is not generated by `ref? mut? $ident` we want
// to suggest either switching the order or note that intersection
// patterns are not allowed.

fn main() {
    let s: Option<u8> = None;

    match s {
        Some(x) @ y => {}
        //~^ ERROR pattern on wrong side of `@`
        //~| pattern on the left, should be on the right
        //~| binding on the right, should be on the left
        //~| HELP switch the order
        //~| SUGGESTION y @ Some(x)
        _ => {}
    }

    match s {
        Some(x) @ Some(y) => {}
        //~^ ERROR left-hand side of `@` must be a binding
        //~| interpreted as a pattern, not a binding
        //~| also a pattern
        //~| NOTE bindings are `x`, `mut x`, `ref x`, and `ref mut x`
        _ => {}
    }

    match 2 {
        1 ..= 5 @ e => {}
        //~^ ERROR pattern on wrong side of `@`
        //~| pattern on the left, should be on the right
        //~| binding on the right, should be on the left
        //~| HELP switch the order
        //~| SUGGESTION e @ 1 ..=5
        _ => {}
    }
}
